package gov.va.genisis2.vo;

import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.AbstractMockMvcTests;

/**
 * 
 * @author1 Janet Lopez
 * 
 * The Class CopyTableDomainsTest.
 * 
 * Description: In this CopyTableDomainsTest Class which extends the abstract
 * class, AbstractMockMvcTests, junit tests are defined.
 * 
 */
public class CopyTableDomainsTest extends AbstractMockMvcTests {
	
	/** The LOGGER. */
	private static final Logger LOGGER = LoggerFactory.getLogger(CopyTableDomainsTest.class);

	/**
	 * Test copy table domain.
	 */
	@Test
	public void TestCopyTableDomain() {
		LOGGER.info("**********Junit Test Copy Table Domains**********");
		
		CopyTableDomains copyTableDomains = new CopyTableDomains("sourceDBNameTestOne", "destinationDBNameTestOne",
				"sourceDBServerNameTestOne", "destinationDBServerNameTestOne", "sUsernameTestOne", "dUsernameTestOne");
		Assert.assertEquals("destinationDBNameTestOne", copyTableDomains.getDestinationDBName());
		Assert.assertEquals("destinationDBServerNameTestOne", copyTableDomains.getDestinationDBServerName());
		Assert.assertEquals("dUsernameTestOne", copyTableDomains.getdUsername());
		Assert.assertEquals("sourceDBNameTestOne", copyTableDomains.getSourceDBName());
		Assert.assertEquals("sourceDBServerNameTestOne", copyTableDomains.getSourceDBServerName());
		Assert.assertEquals("sUsernameTestOne", copyTableDomains.getsUsername());

		LOGGER.info("**********Junit Test Copy Table Domains**********", copyTableDomains.toString());
		copyTableDomains.setDestinationDBName("destinationDBName");
		copyTableDomains.setDestinationDBServerName("destinationDBServerName");
		copyTableDomains.setdUsername("dUsername");
		copyTableDomains.setSourceDBName("sourceDBName");
		copyTableDomains.setSourceDBServerName("sourceDBServerName");
		copyTableDomains.setsUsername("sUsername");

		LOGGER.info("**********Junit Test Copy Table Domains**********", copyTableDomains.toString());
		Assert.assertEquals("destinationDBName", copyTableDomains.getDestinationDBName());
		Assert.assertEquals("destinationDBServerName", copyTableDomains.getDestinationDBServerName());
		Assert.assertEquals("dUsername", copyTableDomains.getdUsername());
		Assert.assertEquals("sourceDBName", copyTableDomains.getSourceDBName());
		Assert.assertEquals("sourceDBServerName", copyTableDomains.getSourceDBServerName());
		Assert.assertEquals("sUsername", copyTableDomains.getsUsername());

		copyTableDomains = new CopyTableDomains();

		Assert.assertNull(copyTableDomains.getDestinationDBName());
		Assert.assertNull(copyTableDomains.getDestinationDBServerName());
		Assert.assertNull(copyTableDomains.getdUsername());
		Assert.assertNull(copyTableDomains.getSourceDBName());
		Assert.assertNull(copyTableDomains.getSourceDBServerName());
		Assert.assertNull(copyTableDomains.getsUsername());

		LOGGER.info("**********End of Test Junit Copy Table Domains**********");

	}
}
